#include "ShaderConstants.fxh"

float4 glintBlend(float4 dest, float4 source) {
	return float4(source.rgb * source.rgb, 0.0) + dest;
}

struct PS_Input
{
	float4 position : SV_Position;
	float4 color : COLOR;
	float2 uv : TEXCOORD_0;

#ifdef ENABLE_FOG
	float4 fogColor : FOG_COLOR;
#endif

#ifdef GLINT
	float2 layer1UV : UV_1;
	float2 layer2UV : UV_2;
#endif
};

struct PS_Output
{
	float4 color : SV_Target;
};

#include "dect.fxh"

ROOT_SIGNATURE
void main(in PS_Input PSInput, out PS_Output PSOutput)
{
#ifdef EFFECTS_OFFSET
	float4 diffuse = TEXTURE_0.Sample(TextureSampler0, PSInput.uv + EFFECT_UV_OFFSET);
#else
	float4 diffuse = TEXTURE_0.Sample(TextureSampler0, PSInput.uv);
#endif

#ifdef MULTI_COLOR_TINT
	// Texture is a mask for tinting with two colors
	float2 colorMask = diffuse.rg;

	// Apply the base color tint
	diffuse.rgb = colorMask.rrr * PSInput.color.rgb;

	// Apply the secondary color mask and tint so long as its grayscale value is not 0
	diffuse.rgb = lerp(diffuse.rgb, colorMask.ggg * CHANGE_COLOR, ceil(colorMask.g));
	
#endif

#ifdef ALPHA_TEST

#ifdef ENABLE_VERTEX_TINT_MASK
	if( diffuse.a <= 0.0f )
#else
	if (diffuse.a <= 0.5f)
#endif
	{
		discard;
	}
#endif

#if defined(ENABLE_VERTEX_TINT_MASK) && !defined(MULTI_COLOR_TINT)
	diffuse.rgb = lerp(diffuse.rgb, diffuse.rgb*PSInput.color.rgb, diffuse.a);
	if (PSInput.color.a > 0.0f) {
		diffuse.a = diffuse.a > 0.0f ? 1.0f : 0.0f; // This line is needed for horse armour icon and dyed leather to work properly
	}
#endif

#ifdef GLINT
	float4 layer1 = TEXTURE_1.Sample(TextureSampler1, frac(PSInput.layer1UV)).rgbr * GLINT_COLOR;
	float4 layer2 = TEXTURE_1.Sample(TextureSampler1, frac(PSInput.layer2UV)).rgbr * GLINT_COLOR;
	float4 glint = (layer1 + layer2);
	glint.rgb *= PSInput.color.a;

	#ifdef INVENTORY
		diffuse.rgb = glint.rgb;
	#else
		diffuse.rgb = glintBlend(diffuse, glint).rgb;
	#endif
#endif

#ifdef USE_OVERLAY
		//use either the diffuse or the OVERLAY_COLOR
	diffuse.rgb = lerp( diffuse, OVERLAY_COLOR, OVERLAY_COLOR.a ).rgb;
#endif

#ifdef ENABLE_VERTEX_TINT_MASK

#ifdef ENABLE_CURRENT_ALPHA_MULTIPLY
	diffuse = diffuse * float4(1.0f, 1.0f, 1.0f, HUD_OPACITY);
#endif

#elif !defined(MULTI_COLOR_TINT)
	diffuse = diffuse * PSInput.color;
#endif

    float4 temp = TEXTURE_1.Sample(TextureSampler1, float2(0.0,1.0) );
    float dia = max(0.0, min( 1.0,(temp.r - 0.5) * 2.0));
    float chuva = Rain(FOG_CONTROL);
    float dss = lerp(lerp( 0.0, 2.5, clamp((1.-max(0.0, min( 1.0, (temp.r - 0.48) * 2.0))*(1.5+chuva))*2.5, .0, 1.)*clamp((temp.r -.15)*1.0,0.,1.)),0.5,lerp(0.0,5.0,pow(max(min(1.0-temp.r*1.5,1.0),0.0),1.2)));
    float3 La = float3(0.5,0.1,-0.3);
    float3 Lb = float3(0.5,0.1,-0.3) * 0.5;
    float pisc = 0.2 * cos(TIME * 0.3 * cos(0.3 * TIME));
	float3 L = lerp(La, Lb, lerp(pisc,0.0,lerp(0.0,1.,pow(PSInput.color.x,9.0))));
    float3 Cc = lerp(diffuse.rgb*float3(0.5,0.5,0.5)*1.2, diffuse.rgb + diffuse.rgb  * (L * 1.5 -0.5),pow(PSInput.color.x,9.0));
    float3 Cd = lerp(lerp(diffuse.rgb*0.3, diffuse.rgb*float3(1.4,1.4,1.4),pow(PSInput.color.x,9.0)),Cc,chuva);
    float3 Cn =  lerp(diffuse.rgb*max(float3(0.3,0.3,0.3), lerp(float3(0.0,0.0,1.0),float3(0.0,0.0,0.0),chuva)), diffuse.rgb + diffuse.rgb  * (L * 1.5 -0.5),pow(PSInput.color.x,9.0));
    

if(End(FOG_COLOR)){
    diffuse.rgb *= float3(0.511,0.362,0.985);
    diffuse.rgb += lerp(float3(0.0,0.0,0.0), diffuse.rgb * float3(0.511,0.362,0.985) * 1.2 , pow(PSInput.color.x, 2.0));
}else{
if(Nether(FOG_CONTROL)){
	float3 La = float3(0.5,0.1,-0.3);
	//nether do fumaça
	diffuse.rgb += lerp(float3(0.0,0.0,0.0), lerp(La, La * 5.0, pow(PSInput.color.x, 0.8)), clamp(FOG_COLOR.x - 0.1, 0.0, 1.0));
	//nether gases de azul
	diffuse.rgb *= lerp(diffuse.rgb, float3(0.1,0.1,4.0), clamp(FOG_COLOR.y - (FOG_COLOR.x - 0.1), 0.0, 1.0));
	diffuse.rgb += lerp(float3(0.0,0.0,0.0) ,(float3(0.0,0.0,diffuse.b) * 15.0) * pow(PSInput.color.x, 5.0), clamp(FOG_COLOR.y - (FOG_COLOR.x - 0.1), 0.0, 1.0));
    diffuse.rgb += lerp(diffuse.rgb, lerp(-float3(0.0,0.1,0.1) * 3.5, La * 5.0, pow(PSInput.color.x, 3.0)), clamp(FOG_CONTROL.x - FOG_COLOR.y, 0.0, 1.0));
}else{
if(Underwater(FOG_CONTROL)){
    diffuse.r *= 0.3;
	diffuse.rgb *=1.5;
	diffuse.rgb = lerp(diffuse.rgb * float3(0.0, 0.5, 0.9) * 0.6, diffuse.rgb * float3(0.0, 1.0, 1.0), pow(PSInput.color.x, 5.0));
}else{
	
	
	diffuse.rgb = lerp(Cn, Cd,dia);

}}}

	// Fog needs to be applied after the color tinting.
#ifdef ENABLE_FOG
	diffuse.rgb = lerp(diffuse.rgb, PSInput.fogColor.rgb, PSInput.fogColor.a);
#endif

	PSOutput.color = diffuse;
    
#ifdef VR_MODE
	// On Rift, the transition from 0 brightness to the lowest 8 bit value is abrupt, so clamp to 
	// the lowest 8 bit value.
	PSOutput.color = max(PSOutput.color, 1 / 255.0f);
#endif
}